import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JButton;

import java.awt.Color;

/**
 * サンプルクラス
 */
public class JButtonSample {

	/** フレーム */
	private		JFrame		frame		= null;
	/** コンテナ */
	private		Container	con			= null;

	/** ボタン */
	private		JButton		btn			= null;

	/** 押した回数 */
	private		int			count		= 0;

	/**
	 * ここから始まります。
	 */
	public static void main(String[] args){
		JButtonSample sample = new JButtonSample();
		sample.run();
	}

	/**
	 * コンストラクタ
	 */
	public JButtonSample(){
		// superを呼び出す
		super();
	}

	/**
	 * 実行
	 */
	public void run(){

		// フレームを生成
		frame = new JFrame("JButtonSample");
		frame.setSize(600, 600);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// コンテナを取得
		con = frame.getContentPane();

		// レイアウト設定
		con.setLayout(null);

		// ボタンを生成
		btn = new JButton("0回押したよ");

		// ボタンを配置
		con.add(btn);
		btn.setBounds(100, 100, 200, 32);

		// ボタンを押した時の処理
		btn.addActionListener(e -> {
			btn.setText(++count + "回押したよ");
			btn.setBackground((btn.getBackground() == Color.WHITE)?Color.GREEN: Color.WHITE);
		});

		// 表示
		frame.setVisible(true);

	} // end run

}
