/**
 * インターフェースサンプル
 * <pre>
 * インターフェースとして利用可能であることを確認します。。
 * コンパイルが通るだけです。実行しても動きません。
 * </pre>
 */
public interface InterfaceSample {

	/**
	 * default サンプル
	 * <pre>
	 * default を指定しています。
	 * </pre>
	 * @param strData ダミー文字列
	 * @return String ダミー文字列
	 */
	default public String defaultRun(String strData){

		String strProc = "処理があっても、コンパイルが通りますよね " + strData;

		return strProc;

	} // end defaultRun

	/**
	 * static サンプル
	 * <pre>
	 * static を指定しています。
	 * </pre>
	 * @param strData ダミー文字列
	 * @return String ダミー文字列
	 */
	public static String staticRun(String strData){

		String strProc = "処理があっても、コンパイルが通りますよね " + strData;

		return strProc;

	} // end staticRun

}
